/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import java.util.function.Function;

public class RenderManager<G, P, M, D> {
    private Player<P> profile;
    private final ModelRenderManager<D, ?, ?, M> renderManager;
    private final ModelDefinitionLoader<G> loader;
    private Function<P, G> getProfile;
    private Function<G, String> getSkullModel;
    private Function<G, String> getTexture;

    public RenderManager(ModelRenderManager<D, ?, ?, M> renderManager, ModelDefinitionLoader<G> loader, Function<P, G> getProfile) {
        this.renderManager = renderManager;
        this.loader = loader;
        this.getProfile = getProfile;
    }

    public boolean tryBindModel(G gprofile, P player, D buffer, M toBind, String arg, String unique, AnimationEngine.AnimationMode mode) {
        ModelDefinition def;
        Player<?> profile;
        if (gprofile == null) {
            gprofile = this.getProfile.apply(player);
        }
        if ((profile = this.loader.loadPlayer(gprofile, unique)) == null) {
            this.renderManager.unbindModel(toBind);
            return false;
        }
        if (!profile.isModel && this.getTexture != null) {
            String texture = this.getTexture.apply(gprofile);
            String ptexture = this.getTexture.apply(profile.getGameProfile());
            if (texture != null && !Objects.equal((Object)texture, (Object)ptexture)) {
                profile = this.loader.reloadPlayer(gprofile, unique);
            }
            if (profile == null) {
                this.renderManager.unbindModel(toBind);
                return false;
            }
        }
        if ((def = profile.getModelDefinition()) != null) {
            this.profile = profile;
            profile.animState.animationMode = mode;
            if (player != null) {
                profile.updatePlayer(player);
            }
            def.itemTransforms.clear();
            this.renderManager.bindModel(toBind, arg, buffer, def, profile, profile.animState.animationMode);
            this.renderManager.getAnimationEngine().prepareAnimations(profile, profile.animState.animationMode, def);
            return true;
        }
        this.renderManager.unbindModel(toBind);
        return false;
    }

    public Player<P> loadPlayerState(G gprofile, P player, String unique, AnimationEngine.AnimationMode mode) {
        Player<?> profile;
        if (gprofile == null) {
            gprofile = this.getProfile.apply(player);
        }
        if ((profile = this.loader.loadPlayer(gprofile, unique)) == null) {
            return null;
        }
        ModelDefinition def = profile.getModelDefinition();
        if (def != null) {
            this.profile = profile;
            profile.animState.animationMode = mode;
            if (player != null) {
                profile.updatePlayer(player);
            }
            def.itemTransforms.clear();
            return profile;
        }
        return null;
    }

    public void bindPlayerState(Player<P> player, D buffer, M toBind, String arg) {
        if (this.profile != null) {
            ModelDefinition def = this.profile.getModelDefinition();
            this.renderManager.bindModel(toBind, arg, buffer, def, this.profile, this.profile.animState.animationMode);
            this.renderManager.getAnimationEngine().prepareAnimations(this.profile, this.profile.animState.animationMode, def);
        }
    }

    public void unbindClear(M model) {
        this.unbindFlush(model);
        this.clearBoundPlayer();
    }

    public void unbind(M model) {
        this.renderManager.unbindModel(model);
    }

    public void unbindFlush(M model) {
        this.renderManager.flushBatch(model, null);
        this.unbind(model);
    }

    public void bindHand(P player, D buffer, M model) {
        this.tryBindModel(null, player, buffer, model, null, "player", AnimationEngine.AnimationMode.HAND);
    }

    public void bindSkull(G profile, D buffer, M model) {
        Object unique;
        Player<P> prev = this.profile;
        unique = this.getSkullModel == null ? "skull" : ((unique = this.getSkullModel.apply(profile)) == null ? ((unique = this.getTexture == null ? "skull" : this.getTexture.apply(profile)) == null ? "skull" : "skull_tex:" + (String)unique) : "model:" + (String)unique);
        this.tryBindModel(profile, null, buffer, model, null, (String)unique, AnimationEngine.AnimationMode.SKULL);
        this.profile = prev;
    }

    public void bindPlayer(P player, D buffer, M model) {
        if (this.profile != null) {
            this.clearBoundPlayer();
        }
        this.tryBindModel(null, player, buffer, model, null, "player", AnimationEngine.AnimationMode.PLAYER);
    }

    public void bindArmor(M player, M model, int layer) {
        this.renderManager.bindSubModel(player, model, "armor" + layer);
    }

    public void bindElytra(M player, M model) {
        this.renderManager.bindSubModel(player, model, null);
    }

    public void bindSkin(M model, TextureSheetType tex) {
        this.renderManager.bindSkin(model, null, tex);
    }

    public Player<P> getBoundPlayer() {
        return this.profile;
    }

    public void clearBoundPlayer() {
        this.profile = null;
    }

    public void setGetSkullModel(Function<G, String> getSkullModel) {
        this.getSkullModel = getSkullModel;
    }

    public void setGetTexture(Function<G, String> getTexture) {
        this.getTexture = getTexture;
    }

    public <PR> void setGPGetters(Function<G, Multimap<String, PR>> getMap, Function<PR, String> getValue) {
        this.setGetSkullModel(profile -> {
            Object property = Iterables.getFirst((Iterable)((Multimap)getMap.apply(profile)).get((Object)"cpm:model"), null);
            if (property != null) {
                return (String)getValue.apply(property);
            }
            return null;
        });
        this.setGetTexture(profile -> {
            Object property = Iterables.getFirst((Iterable)((Multimap)getMap.apply(profile)).get((Object)"textures"), null);
            if (property != null) {
                return (String)getValue.apply(property);
            }
            return null;
        });
    }

    public void jump(P player) {
        G gprofile = this.getProfile.apply(player);
        Player<?> profile = this.loader.loadPlayer(gprofile, "player");
        if (profile == null) {
            return;
        }
        profile.animState.jump();
    }

    public FormatText getStatus(G gprofile, String unique) {
        Player<?> profile = this.loader.loadPlayer(gprofile, unique);
        if (profile == null) {
            return null;
        }
        ModelDefinition def = profile.getModelDefinition0();
        return def != null ? def.getStatus() : null;
    }
}

