/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.effects;

import com.tom.cpl.math.Rotation;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.effects.IRenderEffect;
import com.tom.cpm.shared.effects.RenderEffects;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.PartPosition;
import java.io.IOException;

public class EffectFirstPersonHandPos
implements IRenderEffect {
    private PartPosition leftHand;
    private PartPosition rightHand;

    public EffectFirstPersonHandPos() {
    }

    public EffectFirstPersonHandPos(PartPosition leftHand, PartPosition rightHand) {
        this.leftHand = leftHand;
        this.rightHand = rightHand;
    }

    @Override
    public void load(IOHelper in) throws IOException {
        this.leftHand = new PartPosition();
        this.leftHand.setRenderScale(in.readVec6b(), new Rotation(in.readAngle(), false), in.readVec6b());
        this.rightHand = new PartPosition();
        this.rightHand.setRenderScale(in.readVec6b(), new Rotation(in.readAngle(), false), in.readVec6b());
    }

    @Override
    public void write(IOHelper out) throws IOException {
        out.writeVec6b(this.leftHand.getRPos());
        out.writeAngle(this.leftHand.getRRotation().asVec3f(true));
        out.writeVec6b(this.leftHand.getRScale());
        out.writeVec6b(this.rightHand.getRPos());
        out.writeAngle(this.rightHand.getRRotation().asVec3f(true));
        out.writeVec6b(this.rightHand.getRScale());
    }

    @Override
    public void apply(ModelDefinition def) {
        def.fpLeftHand = this.leftHand;
        def.fpRightHand = this.rightHand;
    }

    @Override
    public RenderEffects getEffect() {
        return RenderEffects.FIRST_PERSON_HAND;
    }
}

