/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.UI;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.ButtonGroup;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.EmbeddedLocalizations;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.Util;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.Exporter;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.AnimEncConfigPopup;
import com.tom.cpm.shared.editor.gui.popup.CreateGistPopup;
import com.tom.cpm.shared.editor.gui.popup.DescPopup;
import com.tom.cpm.shared.editor.gui.popup.ExportStringResultPopup;
import com.tom.cpm.shared.editor.gui.popup.ScreenshotPopup;
import com.tom.cpm.shared.editor.template.TemplateExporter;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.gui.SelectSkinPopup;
import com.tom.cpm.shared.gui.SkinUploadPopup;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.parts.ModelPartDefinitionLink;
import com.tom.cpm.shared.parts.ModelPartLink;
import com.tom.cpm.shared.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class ExportPopup
extends PopupPanel {
    protected final EditorGui editorGui;
    protected Button ok;
    protected Button modeBtn;

    protected ExportPopup(EditorGui e, int width, int height, ExportMode mode) {
        super(e.getGui());
        this.editorGui = e;
        this.modeBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.export.as_" + mode.name().toLowerCase(Locale.ROOT), new Object[0]), () -> {
            this.close();
            for (int i = mode.ordinal() + 1; i < ExportMode.VALUES.length * 2; ++i) {
                ExportMode em = ExportMode.VALUES[i % ExportMode.VALUES.length];
                if (!em.canDisplay.test(e.getEditor())) continue;
                e.openPopup(em.factory.apply(e));
                return;
            }
        });
        this.modeBtn.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export.as_" + mode.name().toLowerCase(Locale.ROOT), new Object[0])));
        this.modeBtn.setBounds(new Box(5, 5, 170, 20));
        this.addElement(this.modeBtn);
        this.ok = new Button(this.gui, this.gui.i18nFormat("button.cpm.file.export", new Object[0]), this::export);
        this.ok.setBounds(new Box(5, height - 25, 80, 20));
        this.addElement(this.ok);
        this.setBounds(new Box(0, 0, width, height));
    }

    protected void export() {
        if (Exporter.check(this.editorGui.getEditor(), this.editorGui.getGui(), this::export)) {
            this.export0();
            this.close();
        }
    }

    protected abstract void export0();

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.exportSkin", new Object[0]);
    }

    public static boolean isTemplate(Editor e) {
        return e.templateSettings != null;
    }

    private static void openScreenshot(EditorGui e, EditorTexture icon, ExportPopup popup) {
        popup.close();
        e.openPopup(new ScreenshotPopup(e, icon::setImage, () -> e.openPopup(popup)));
    }

    public static PopupPanel createPopup(EditorGui e) {
        for (ExportMode m : ExportMode.VALUES) {
            if (!m.canDisplay.test(e.getEditor())) continue;
            return m.factory.apply(e);
        }
        IGui gui = e.getGui();
        Log.error("Project can't be exported in any format");
        return new MessagePopup(e, gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("error.cpm.unknownError", new Object[0]));
    }

    private static enum ExportMode {
        SKIN(Skin::new, ((Predicate<Editor>)ExportPopup::isTemplate).negate()),
        MODEL(Model::new, ((Predicate<Editor>)ExportPopup::isTemplate).negate()),
        B64(B64::new, ((Predicate<Editor>)ExportPopup::isTemplate).negate()),
        TEMPLATE(Template::new, ExportPopup::isTemplate);

        public static final ExportMode[] VALUES;
        private Function<EditorGui, ExportPopup> factory;
        private Predicate<Editor> canDisplay;

        private ExportMode(Function<EditorGui, ExportPopup> factory, Predicate<Editor> canDisplay) {
            this.factory = factory;
            this.canDisplay = canDisplay;
        }

        static {
            VALUES = ExportMode.values();
        }
    }

    private static class Model
    extends ExportPopup {
        private TextField nameField;
        private TextField descField;
        private EditorTexture icon;
        private Checkbox skinCompat;
        private Checkbox chbxClone;
        private Checkbox chbxUUIDLock;
        private Link defLink;
        private Button okDef;
        private boolean gist;

        protected Model(EditorGui e) {
            super(e, 320, 260, ExportMode.MODEL);
            Editor editor = e.getEditor();
            Label nameLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.name", new Object[0]));
            nameLbl.setBounds(new Box(5, 35, 150, 10));
            this.addElement(nameLbl);
            this.nameField = new TextField(this.gui);
            this.nameField.setBounds(new Box(5, 45, 150, 20));
            this.addElement(this.nameField);
            Label descLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]));
            descLbl.setBounds(new Box(5, 70, 150, 10));
            this.addElement(descLbl);
            this.descField = new TextField(this.gui);
            this.descField.setBounds(new Box(5, 80, 150, 20));
            this.addElement(this.descField);
            this.icon = new EditorTexture();
            if (editor.description != null) {
                this.nameField.setText(editor.description.name);
                this.descField.setText(editor.description.desc);
                if (editor.description.icon != null) {
                    this.icon.setImage(editor.description.icon);
                }
            }
            Button setIcon = new Button(this.gui, this.gui.i18nFormat("button.cpm.setIcon", new Object[0]), () -> ExportPopup.openScreenshot(e, this.icon, this));
            setIcon.setBounds(new Box(5, 105, 100, 20));
            this.addElement(setIcon);
            this.skinCompat = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.export.skinCompat", new Object[0]));
            this.skinCompat.setBounds(new Box(5, 130, 100, 20));
            this.skinCompat.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skinCompat", new Object[0])));
            this.addElement(this.skinCompat);
            this.skinCompat.setAction(() -> this.skinCompat.setSelected(!this.skinCompat.isSelected()));
            this.chbxClone = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.cloneable", new Object[0]));
            this.chbxClone.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.cloneable", new Object[0])));
            this.chbxClone.setBounds(new Box(5, 155, 60, 20));
            this.chbxClone.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.CLONEABLE);
            this.addElement(this.chbxClone);
            this.chbxUUIDLock = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.uuidlock", new Object[0]));
            this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlock", MinecraftClientAccess.get().getClientPlayer().getUUID().toString())));
            this.chbxUUIDLock.setBounds(new Box(5, 180, 60, 20));
            this.chbxUUIDLock.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            this.addElement(this.chbxUUIDLock);
            Button changeUUID = new Button(this.gui, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), new InputPopup(e, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), this.gui.i18nFormat("label.cpm.enterNewUUID", new Object[0]), n -> {
                if (editor.description == null) {
                    editor.description = new ModelDescription();
                }
                try {
                    editor.description.uuid = Util.uuidFromString(n);
                    this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
                }
                catch (IllegalArgumentException ex) {
                    e.openPopup(new MessagePopup(e, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.invalidUUID", new Object[0])));
                }
            }, null));
            changeUUID.setEnabled(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            changeUUID.setBounds(new Box(90, 180, 80, 20));
            this.addElement(changeUUID);
            if (editor.description != null && editor.description.uuid != null) {
                this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
            }
            this.chbxClone.setAction(() -> {
                if (!this.chbxClone.isSelected()) {
                    this.chbxUUIDLock.setSelected(false);
                    this.chbxClone.setSelected(true);
                    changeUUID.setEnabled(false);
                } else {
                    this.chbxClone.setSelected(false);
                }
            });
            this.chbxUUIDLock.setAction(() -> {
                changeUUID.setEnabled(!this.chbxUUIDLock.isSelected());
                if (!this.chbxUUIDLock.isSelected()) {
                    this.chbxUUIDLock.setSelected(true);
                    this.chbxClone.setSelected(false);
                } else {
                    this.chbxUUIDLock.setSelected(false);
                }
            });
            this.okDef = new Button(this.gui, this.gui.i18nFormat("button.cpm.export_def", new Object[0]), () -> {
                if (this.defLink != null) {
                    this.gist = true;
                    this.close();
                    this.export();
                }
            });
            this.okDef.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export_def.model", new Object[0])));
            this.okDef.setBounds(new Box(90, 235, 80, 20));
            this.addElement(this.okDef);
            this.updateLink();
        }

        @Override
        protected void export0() {
            ModelDescription.CopyProtection cp;
            Editor editor = this.editorGui.getEditor();
            if (editor.templateSettings != null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.templateExportAsSkin", new Object[0])));
                return;
            }
            boolean descChanged = false;
            if (editor.description == null) {
                editor.description = new ModelDescription();
                descChanged = true;
            }
            if (!descChanged && !editor.description.name.equals(this.nameField.getText())) {
                descChanged = true;
            }
            if (!descChanged && !editor.description.desc.equals(this.descField.getText())) {
                descChanged = true;
            }
            editor.description.name = this.nameField.getText();
            editor.description.desc = this.descField.getText();
            ModelDescription.CopyProtection copyProtection = this.chbxUUIDLock.isSelected() ? ModelDescription.CopyProtection.UUID_LOCK : (cp = this.chbxClone.isSelected() ? ModelDescription.CopyProtection.CLONEABLE : ModelDescription.CopyProtection.NORMAL);
            if (editor.description.copyProtection != cp) {
                editor.description.copyProtection = cp;
                descChanged = true;
            }
            if (descChanged) {
                editor.markDirty();
            }
            if (this.gist) {
                Exporter.exportUpdate(editor, this.gui, this.defLink);
            } else {
                File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
                modelsDir.mkdirs();
                String fileName = this.nameField.getText().replaceAll("[^a-zA-Z0-9\\.\\-]", "") + ".cpmmodel";
                File selFile = new File(modelsDir, fileName);
                if (selFile.exists()) {
                    this.editorGui.openPopup(new ConfirmPopup(this.editorGui, this.gui.i18nFormat("label.cpm.overwrite", new Object[0]), this.gui.i18nFormat("label.cpm.overwrite", new Object[0]), () -> Exporter.exportModel(editor, this.gui, selFile, editor.description, this.skinCompat.isSelected()), null));
                } else {
                    Exporter.exportModel(editor, this.gui, selFile, editor.description, this.skinCompat.isSelected());
                }
            }
        }

        private void updateLink() {
            File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
            modelsDir.mkdirs();
            String fileName = this.nameField.getText().replaceAll("[^a-zA-Z0-9\\.\\-]", "") + ".cpmmodel";
            File selFile = new File(modelsDir, fileName);
            this.defLink = null;
            boolean incompatibleDef = false;
            if (selFile.exists()) {
                try {
                    ModelPartLink link;
                    ModelFile mf = ModelFile.load(selFile);
                    ModelDefinition def = MinecraftClientAccess.get().getDefinitionLoader().loadModel(mf.getDataBlock(), MinecraftClientAccess.get().getClientPlayer());
                    if (def != null && (link = def.findDefLink()) != null) {
                        this.defLink = link.getLink();
                        if (link instanceof ModelPartDefinitionLink == ModConfig.getCommonConfig().getBoolean("experimentalExport0614", false)) {
                            this.defLink = null;
                            incompatibleDef = true;
                        }
                    }
                }
                catch (IOException e) {
                    Log.error("Failed to load file", e);
                }
            }
            this.okDef.setEnabled(this.defLink != null);
            if (this.defLink != null) {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def.model", new Object[0])));
            } else if (incompatibleDef) {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def.incompatible", new Object[0])));
            } else {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def.noLink.model", new Object[0])));
            }
        }

        @Override
        public void onClosed() {
            this.icon.free();
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (this.icon.getImage() != null) {
                this.gui.drawBox(this.bounds.x + this.bounds.w - 136, this.bounds.y + 14, 130, 130, this.gui.getColors().color_picker_border);
                this.gui.drawBox(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, -1);
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
    }

    private static class B64
    extends ExportPopup {
        private Checkbox forceLinkFile;
        private Checkbox chbxClone;

        protected B64(EditorGui e) {
            super(e, 180, 150, ExportMode.B64);
            this.forceLinkFile = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.force_link_file", new Object[0]));
            this.addElement(this.forceLinkFile);
            this.forceLinkFile.setAction(() -> this.forceLinkFile.setSelected(!this.forceLinkFile.isSelected()));
            this.forceLinkFile.setBounds(new Box(5, 55, 135, 20));
            this.chbxClone = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.cloneable", new Object[0]));
            this.chbxClone.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.cloneable", new Object[0])));
            this.chbxClone.setBounds(new Box(5, 80, 60, 20));
            this.addElement(this.chbxClone);
            this.chbxClone.setAction(() -> this.chbxClone.setSelected(!this.chbxClone.isSelected()));
            Button btnEditDesc = new Button(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]), () -> e.openPopup(new DescPopup(e, false, this::updateDesc)));
            btnEditDesc.setBounds(new Box(90, 80, 85, 20));
            this.addElement(btnEditDesc);
            this.updateDesc();
        }

        private void updateDesc() {
            Editor editor = this.editorGui.getEditor();
            this.chbxClone.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.CLONEABLE);
        }

        @Override
        protected void export0() {
            if (this.editorGui.getEditor().templateSettings != null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.templateExportAsSkin", new Object[0])));
                return;
            }
            Editor e = this.editorGui.getEditor();
            if (e.description == null && this.chbxClone.isSelected()) {
                e.description = new ModelDescription();
                e.markDirty();
            }
            if (e.description != null) {
                ModelDescription.CopyProtection cp;
                ModelDescription.CopyProtection copyProtection = cp = this.chbxClone.isSelected() ? ModelDescription.CopyProtection.CLONEABLE : e.description.copyProtection;
                if (e.description.copyProtection != cp) {
                    e.description.copyProtection = cp;
                    e.markDirty();
                }
            }
            Exporter.exportB64(this.editorGui.getEditor(), this.gui, b64 -> this.editorGui.openPopup(new ExportStringResultPopup(this.editorGui, "base64_model", (String)b64)), this.forceLinkFile.isSelected());
        }
    }

    private static class Template
    extends ExportPopup {
        private TextField nameField;
        private TextField descField;
        private EditorTexture icon;

        protected Template(EditorGui e) {
            super(e, 320, 190, ExportMode.TEMPLATE);
            Editor editor = e.getEditor();
            Label nameLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.name", new Object[0]));
            nameLbl.setBounds(new Box(5, 55, 150, 10));
            this.addElement(nameLbl);
            this.nameField = new TextField(this.gui);
            this.nameField.setBounds(new Box(5, 65, 150, 20));
            this.addElement(this.nameField);
            Label descLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]));
            descLbl.setBounds(new Box(5, 90, 150, 10));
            this.addElement(descLbl);
            this.descField = new TextField(this.gui);
            this.descField.setBounds(new Box(5, 100, 150, 20));
            this.addElement(this.descField);
            this.icon = new EditorTexture();
            if (editor.description != null) {
                this.nameField.setText(editor.description.name);
                this.descField.setText(editor.description.desc);
                if (editor.description.icon != null) {
                    this.icon.setImage(editor.description.icon);
                }
            }
            Button setIcon = new Button(this.gui, this.gui.i18nFormat("button.cpm.setIcon", new Object[0]), () -> ExportPopup.openScreenshot(e, this.icon, this));
            setIcon.setBounds(new Box(5, 125, 100, 20));
            this.addElement(setIcon);
        }

        @Override
        protected void export0() {
            Editor editor = this.editorGui.getEditor();
            if (editor.templateSettings == null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.projectNotTemplate", new Object[0])));
                return;
            }
            if (editor.description == null) {
                editor.description = new ModelDescription();
            }
            editor.description.name = this.nameField.getText();
            editor.description.desc = this.descField.getText();
            editor.markDirty();
            TemplateExporter.exportTemplate(editor, this.gui, editor.description, t -> this.editorGui.openPopup(new CreateGistPopup(this.editorGui, this.gui, "template_export", (String)t, l -> this.editorGui.openPopup(new ExportStringResultPopup(this.editorGui, "template", l.toString())))));
        }

        @Override
        public void onClosed() {
            this.icon.free();
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (this.icon.getImage() != null) {
                this.gui.drawBox(this.bounds.x + this.bounds.w - 136, this.bounds.y + 14, 130, 130, this.gui.getColors().color_picker_border);
                this.gui.drawBox(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, -1);
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
    }

    private static class Skin
    extends ExportPopup {
        private EditorTexture vanillaSkin;
        private Button okDef;
        private Button okUpload;
        private Button changeUUID;
        private File selFile;
        private Checkbox forceLinkFile;
        private Checkbox chbxClone;
        private Checkbox chbxUUIDLock;
        private Link defLink;
        private Tooltip vanillaSkinTooltip;
        private boolean gist;
        private boolean upload;
        private SkinType skinType;
        private ButtonGroup<SkinType, Checkbox> groupSkinType;

        protected Skin(EditorGui e) {
            super(e, 320, 280, ExportMode.SKIN);
            Editor editor = e.getEditor();
            this.skinType = editor.skinType;
            this.vanillaSkin = new EditorTexture();
            this.vanillaSkin.setImage(editor.vanillaSkin);
            Button encSettings = new Button(this.gui, this.gui.i18nFormat("button.cpm.animEncSettings", new Object[0]), () -> e.openPopup(new AnimEncConfigPopup(this.gui, editor, this.vanillaSkin::markDirty)));
            encSettings.setBounds(new Box(5, 30, 170, 20));
            this.addElement(encSettings);
            Button changeVanillaSkin = new Button(this.gui, this.gui.i18nFormat("button.cpm.change_vanilla_skin", new Object[0]), () -> {
                SelectSkinPopup ssp = new SelectSkinPopup(e, this.skinType, (type, img) -> {
                    this.skinType = type;
                    this.groupSkinType.accept((SkinType)((Object)((Object)type)));
                    editor.vanillaSkin = img;
                    this.vanillaSkin.setImage((Image)img);
                    this.detectLink();
                });
                ssp.setOnClosed(() -> editor.displayViewport.accept(true));
                e.openPopup(ssp);
                editor.displayViewport.accept(false);
            });
            changeVanillaSkin.setBounds(new Box(this.bounds.w - 135, this.bounds.y + 150, 128, 20));
            this.addElement(changeVanillaSkin);
            Label vanillaSkinLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.vanilla_skin", new Object[0]));
            vanillaSkinLbl.setBounds(new Box(185, 5, 0, 0));
            this.addElement(vanillaSkinLbl);
            this.forceLinkFile = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.force_link_file", new Object[0]));
            this.addElement(this.forceLinkFile);
            this.forceLinkFile.setBounds(new Box(5, 80, 135, 20));
            this.forceLinkFile.setAction(() -> this.forceLinkFile.setSelected(!this.forceLinkFile.isSelected()));
            this.forceLinkFile.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.force_link_file", new Object[0])));
            Label expOutLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.export_output", new Object[0]));
            expOutLbl.setBounds(new Box(5, 160, 0, 0));
            this.addElement(expOutLbl);
            Label exportName = new Label(this.gui, this.gui.i18nFormat("label.cpm.no_file", new Object[0]));
            exportName.setBounds(new Box(5, 175, 0, 0));
            this.addElement(exportName);
            Button setOut = new Button(this.gui, "...", () -> {
                FileChooserPopup fc = new FileChooserPopup(e);
                fc.setTitle(EmbeddedLocalizations.exportSkin);
                fc.setFileDescText(EmbeddedLocalizations.filePng);
                fc.setFilter(new FileChooserPopup.FileFilter("png"));
                fc.setSaveDialog(true);
                fc.setExtAdder(n -> n + ".png");
                fc.setAccept(f -> {
                    this.selFile = f;
                    this.ok.setEnabled(true);
                    this.ok.setTooltip(null);
                    exportName.setText(f.getName());
                });
                fc.setButtonText(this.gui.i18nFormat("button.cpm.ok", new Object[0]));
                e.openPopup(fc);
            });
            setOut.setBounds(new Box(150, 170, 25, 20));
            this.addElement(setOut);
            this.chbxClone = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.cloneable", new Object[0]));
            this.chbxClone.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.cloneable", new Object[0])));
            this.chbxClone.setBounds(new Box(5, 105, 60, 20));
            this.addElement(this.chbxClone);
            Button btnEditDesc = new Button(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]), () -> e.openPopup(new DescPopup(e, false, this::updateDesc)));
            btnEditDesc.setBounds(new Box(90, 105, 85, 20));
            this.addElement(btnEditDesc);
            this.chbxUUIDLock = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.uuidlock", new Object[0]));
            this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlock", MinecraftClientAccess.get().getClientPlayer().getUUID().toString())));
            this.chbxUUIDLock.setBounds(new Box(5, 130, 60, 20));
            this.addElement(this.chbxUUIDLock);
            this.changeUUID = new Button(this.gui, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), new InputPopup(e, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), this.gui.i18nFormat("label.cpm.enterNewUUID", new Object[0]), n -> {
                if (editor.description == null) {
                    editor.description = new ModelDescription();
                }
                try {
                    editor.description.uuid = Util.uuidFromString(n);
                    this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
                }
                catch (IllegalArgumentException ex) {
                    e.openPopup(new MessagePopup(e, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.invalidUUID", new Object[0])));
                }
            }, null));
            this.changeUUID.setBounds(new Box(90, 130, 85, 20));
            this.addElement(this.changeUUID);
            this.chbxClone.setAction(() -> {
                if (!this.chbxClone.isSelected()) {
                    this.chbxUUIDLock.setSelected(false);
                    this.chbxClone.setSelected(true);
                    this.changeUUID.setEnabled(false);
                } else {
                    this.chbxClone.setSelected(false);
                }
            });
            this.chbxUUIDLock.setAction(() -> {
                this.changeUUID.setEnabled(!this.chbxUUIDLock.isSelected());
                if (!this.chbxUUIDLock.isSelected()) {
                    this.chbxUUIDLock.setSelected(true);
                    this.chbxClone.setSelected(false);
                } else {
                    this.chbxUUIDLock.setSelected(false);
                }
            });
            this.okDef = new Button(this.gui, this.gui.i18nFormat("button.cpm.export_def", new Object[0]), () -> {
                if (this.defLink != null) {
                    this.gist = true;
                    this.close();
                    this.export();
                }
            });
            this.okDef.setBounds(new Box(90, this.bounds.h - 25, 80, 20));
            this.addElement(this.okDef);
            this.okUpload = new Button(this.gui, this.gui.i18nFormat("button.cpm.export.skin.exportApply", new Object[0]), () -> {
                this.upload = true;
                this.close();
                this.export();
            });
            this.okUpload.setBounds(new Box(175, this.bounds.h - 25, 100, 20));
            if (MinecraftClientAccess.get().getServerSideStatus() != MinecraftClientAccess.ServerStatus.OFFLINE) {
                this.okUpload.setEnabled(false);
                this.okUpload.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.cantUploadIngame", new Object[0])));
            } else {
                this.okUpload.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.exportApply", new Object[0])));
            }
            this.addElement(this.okUpload);
            this.groupSkinType = new ButtonGroup<SkinType, Checkbox>(Checkbox::setSelected, Checkbox::setAction, i -> {
                this.skinType = i;
            });
            for (int j = 0; j < SkinType.VANILLA_TYPES.length; ++j) {
                SkinType s = SkinType.VANILLA_TYPES[j];
                Checkbox chbxSt = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.skin_type." + s.getName(), new Object[0]));
                chbxSt.setBounds(new Box(this.bounds.w - 135, this.bounds.y + 175 + j * 25, 60, 20));
                this.addElement(chbxSt);
                this.groupSkinType.addElement(s, chbxSt);
            }
            this.groupSkinType.accept(this.skinType);
            this.ok.setEnabled(false);
            this.ok.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.noFile", new Object[0])));
            this.detectLink();
            this.updateDesc();
            this.vanillaSkinTooltip = new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.vanillaSkinInfo", new Object[0]));
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 136, this.bounds.y + 14, 130, 130, this.gui.getColors().color_picker_border);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, -1);
            this.vanillaSkin.bind();
            this.gui.drawTexture(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, 0.0f, 0.0f, 1.0f, 1.0f);
            if (event.isHovered(new Box(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128))) {
                this.vanillaSkinTooltip.set();
            }
        }

        private void updateDesc() {
            Editor editor = this.editorGui.getEditor();
            this.chbxClone.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.CLONEABLE);
            this.chbxUUIDLock.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            this.changeUUID.setEnabled(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            if (editor.description != null && editor.description.uuid != null) {
                this.chbxUUIDLock.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
            }
        }

        @Override
        public void onClosed() {
            this.vanillaSkin.free();
        }

        private void detectLink() {
            ModelPartLink link;
            ModelDefinition def = MinecraftClientAccess.get().getDefinitionLoader().loadModel(this.editorGui.getEditor().vanillaSkin, MinecraftClientAccess.get().getClientPlayer());
            boolean incompatibleDef = false;
            if (def != null && (link = def.findDefLink()) != null) {
                this.defLink = link.getLink();
                if (link instanceof ModelPartDefinitionLink == ModConfig.getCommonConfig().getBoolean("experimentalExport0614", false)) {
                    this.defLink = null;
                    incompatibleDef = true;
                }
            }
            this.okDef.setEnabled(this.defLink != null);
            if (this.defLink != null) {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def", new Object[0])));
            } else if (incompatibleDef) {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def.incompatible", new Object[0])));
            } else {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def.noLink", new Object[0])));
            }
        }

        @Override
        protected void export0() {
            Editor e = this.editorGui.getEditor();
            if (this.editorGui.getEditor().templateSettings != null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.templateExportAsSkin", new Object[0])));
                return;
            }
            if (e.description == null && (this.chbxClone.isSelected() || this.chbxUUIDLock.isSelected())) {
                e.description = new ModelDescription();
                e.markDirty();
            }
            if (e.description != null) {
                ModelDescription.CopyProtection cp;
                ModelDescription.CopyProtection copyProtection = this.chbxUUIDLock.isSelected() ? ModelDescription.CopyProtection.UUID_LOCK : (cp = this.chbxClone.isSelected() ? ModelDescription.CopyProtection.CLONEABLE : ModelDescription.CopyProtection.NORMAL);
                if (e.description.copyProtection != cp) {
                    e.description.copyProtection = cp;
                    e.markDirty();
                }
            }
            if (e.skinType != this.skinType) {
                if (e.elements.stream().anyMatch(m -> !m.hidden)) {
                    this.editorGui.openPopup(new ConfirmPopup(this.editorGui, this.gui.i18nFormat("label.cpm.confirmSkinTypeEdit", this.gui.i18nFormat("label.cpm.skin_type." + e.skinType.getName(), new Object[0]), this.gui.i18nFormat("label.cpm.skin_type." + this.skinType.getName(), new Object[0])), () -> {
                        e.skinType = this.skinType;
                        e.markDirty();
                        this.export1();
                    }, null));
                    return;
                }
                e.skinType = this.skinType;
                e.markDirty();
            }
            this.export1();
        }

        private void export1() {
            Editor e = this.editorGui.getEditor();
            if (this.gist) {
                Exporter.exportUpdate(e, this.gui, this.defLink);
            } else if (this.upload) {
                this.editorGui.openPopup(new ConfirmPopup(this.editorGui, this.gui.i18nFormat("label.cpm.export.upload", new Object[0]), this.gui.i18nFormat("label.cpm.export.upload.desc", new Object[0]), () -> Exporter.exportSkin(e, (UI)this.gui, img -> new SkinUploadPopup(this.editorGui, e.skinType, (Image)img).start(), this.forceLinkFile.isSelected()), null));
            } else {
                Exporter.exportSkin(e, (UI)this.gui, this.selFile, this.forceLinkFile.isSelected());
            }
        }
    }
}

