/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.ButtonGroup;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.ScreenshotPopup;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.model.SkinType;

public class DescPopup
extends PopupPanel {
    private EditorTexture icon;
    private SkinType skinType;

    public DescPopup(EditorGui g, boolean skinTypeSettings, Runnable onOk) {
        super(g.getGui());
        this.setBounds(new Box(0, 0, 320, 220));
        Editor editor = g.getEditor();
        this.skinType = editor.skinType;
        Label nameLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.name", new Object[0]));
        nameLbl.setBounds(new Box(5, 5, 130, 10));
        this.addElement(nameLbl);
        TextField nameField = new TextField(this.gui);
        nameField.setBounds(new Box(5, 15, 130, 20));
        this.addElement(nameField);
        Label descLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]));
        descLbl.setBounds(new Box(5, 40, 130, 10));
        this.addElement(descLbl);
        TextField descField = new TextField(this.gui);
        descField.setBounds(new Box(5, 50, 130, 20));
        this.addElement(descField);
        this.icon = new EditorTexture();
        if (editor.description != null) {
            nameField.setText(editor.description.name);
            descField.setText(editor.description.desc);
            if (editor.description.icon != null) {
                this.icon.setImage(editor.description.icon);
            }
        }
        Button setIcon = new Button(this.gui, this.gui.i18nFormat("button.cpm.setIcon", new Object[0]), () -> DescPopup.openScreenshot(g, this.icon, this));
        setIcon.setBounds(new Box(5, 80, 100, 20));
        this.addElement(setIcon);
        Checkbox chbxClone = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.cloneable", new Object[0]));
        chbxClone.setTooltip(new Tooltip(g, this.gui.i18nFormat("tooltip.cpm.cloneable", new Object[0])));
        chbxClone.setBounds(new Box(5, 110, 60, 20));
        chbxClone.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.CLONEABLE);
        this.addElement(chbxClone);
        Checkbox chbxUUIDLock = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.uuidlock", new Object[0]));
        chbxUUIDLock.setTooltip(new Tooltip(g, this.gui.i18nFormat("tooltip.cpm.uuidlock", MinecraftClientAccess.get().getClientPlayer().getUUID().toString())));
        chbxUUIDLock.setBounds(new Box(5, 135, 60, 20));
        chbxUUIDLock.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
        this.addElement(chbxUUIDLock);
        chbxClone.setAction(() -> {
            if (!chbxClone.isSelected()) {
                chbxUUIDLock.setSelected(false);
                chbxClone.setSelected(true);
            } else {
                chbxClone.setSelected(false);
            }
        });
        chbxUUIDLock.setAction(() -> {
            if (!chbxUUIDLock.isSelected()) {
                chbxUUIDLock.setSelected(true);
                chbxClone.setSelected(false);
            } else {
                chbxUUIDLock.setSelected(false);
            }
        });
        if (skinTypeSettings) {
            ButtonGroup<SkinType, Checkbox> group = new ButtonGroup<SkinType, Checkbox>(Checkbox::setSelected, Checkbox::setAction, i -> {
                this.skinType = i;
            });
            for (int j = 0; j < SkinType.VANILLA_TYPES.length; ++j) {
                SkinType s = SkinType.VANILLA_TYPES[j];
                Checkbox chbxSt = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.skin_type." + s.getName(), new Object[0]));
                chbxSt.setBounds(new Box(this.bounds.w - 135, this.bounds.y + 5 + j * 25, 60, 20));
                this.addElement(chbxSt);
                group.addElement(s, chbxSt);
            }
            group.accept(this.skinType);
        }
        Label modelIdLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.modelPropertyId", new Object[0]));
        modelIdLbl.setBounds(new Box(5, 160, 130, 10));
        modelIdLbl.setTooltip(new Tooltip(g, this.gui.i18nFormat("tooltip.cpm.modelPropertyId", new Object[0])));
        this.addElement(modelIdLbl);
        TextField modelIdField = new TextField(this.gui);
        modelIdField.setBounds(new Box(5, 170, 130, 20));
        if (editor.modelId != null) {
            modelIdField.setText(editor.modelId);
        }
        this.addElement(modelIdField);
        Button ok = new Button(this.gui, this.gui.i18nFormat("button.cpm.ok", new Object[0]), () -> {
            if (skinTypeSettings && editor.skinType != this.skinType) {
                if (editor.elements.stream().anyMatch(m -> !m.hidden)) {
                    g.openPopup(new ConfirmPopup(g, this.gui.i18nFormat("label.cpm.confirmSkinTypeEdit", this.gui.i18nFormat("label.cpm.skin_type." + editor.skinType.getName(), new Object[0]), this.gui.i18nFormat("label.cpm.skin_type." + this.skinType.getName(), new Object[0])), () -> {
                        editor.skinType = this.skinType;
                        editor.markDirty();
                    }, null));
                } else {
                    editor.skinType = this.skinType;
                    editor.markDirty();
                }
            }
            if (editor.description == null) {
                editor.description = new ModelDescription();
            }
            editor.description.name = nameField.getText();
            editor.description.desc = descField.getText();
            ModelDescription.CopyProtection copyProtection = chbxUUIDLock.isSelected() ? ModelDescription.CopyProtection.UUID_LOCK : (editor.description.copyProtection = chbxClone.isSelected() ? ModelDescription.CopyProtection.CLONEABLE : ModelDescription.CopyProtection.NORMAL);
            if (!modelIdField.getText().isEmpty()) {
                editor.modelId = modelIdField.getText();
            }
            editor.markDirty();
            this.close();
            if (onOk != null) {
                onOk.run();
            }
        });
        ok.setBounds(new Box(5, 195, 60, 20));
        this.addElement(ok);
    }

    @Override
    public void onClosed() {
        this.icon.free();
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        super.draw(event, partialTicks);
        if (this.icon.getImage() != null) {
            int y = 55;
            this.gui.drawBox(this.bounds.x + this.bounds.w - 136, this.bounds.y + y, 130, 130, this.gui.getColors().color_picker_border);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 135, this.bounds.y + y + 1, 128, 128, -1);
            this.icon.bind();
            this.gui.drawTexture(this.bounds.x + this.bounds.w - 135, this.bounds.y + y + 1, 128, 128, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    private static void openScreenshot(EditorGui e, EditorTexture icon, DescPopup popup) {
        popup.close();
        e.openPopup(new ScreenshotPopup(e, icon::setImage, () -> e.openPopup(popup)));
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.desc", new Object[0]);
    }
}

