/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.ListElement;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec2i;
import java.util.List;

public class ListElement2d<T>
extends ListElement<T> {
    private int preferredWidth;

    public ListElement2d(IGui gui, ListElement.ListModel<T> model, List<T> elems) {
        super(gui, model, elems);
    }

    @Override
    public void mouseClick(MouseEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        if (this.bounds.isInBounds(evt.x, evt.y)) {
            int cols;
            int rowSel;
            int colW = this.getMaxWidth();
            int colSel = evt.x / colW;
            int elem = colSel + (rowSel = (evt.y - this.bounds.y) / 10) * (cols = Math.max(this.preferredWidth / colW, 1));
            this.selected = elem >= 0 && elem < this.elements.size() ? this.elements.get(elem) : null;
            this.model.selected(this.selected);
            evt.consume();
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        int colW = this.getMaxWidth();
        int cols = Math.max(this.preferredWidth / colW, 1);
        for (int i = 0; i < this.elements.size(); ++i) {
            Object el = this.elements.get(i);
            int x = i % cols;
            int y = i / cols;
            boolean hovered = false;
            if (event.isHovered(this.bounds) && event.isHovered(new Box(this.bounds.x + x * colW, this.bounds.y + y * 10, colW, 10))) {
                hovered = true;
                Tooltip tt = this.model.getTooltip(el);
                if (tt != null) {
                    tt.set();
                }
            }
            this.model.draw(this.gui, el, this.bounds.x + x * colW, this.bounds.y + y * 10, colW, 10, hovered, el == this.selected);
        }
    }

    @Override
    public Vec2i getSize() {
        int colW = this.getMaxWidth();
        int cols = Math.max(this.preferredWidth / colW, 1);
        return new Vec2i(colW * cols, MathHelper.ceil((float)this.elements.size() / (float)cols) * 10);
    }

    private int getMaxWidth() {
        int w = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            Object el = this.elements.get(i);
            w = Math.max(w, this.model.getWidth(this.gui, el));
        }
        return w + 10;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }
}

