/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.block;

import com.tom.cpl.block.Biome;
import com.tom.cpl.tag.NativeTagManager;
import java.util.List;

public abstract class BiomeHandler<B>
implements NativeTagManager<Biome> {
    public Biome wrap(B stack) {
        return new Biome(this, stack);
    }

    public B unwrap(Biome state) {
        return (B)state.getBiome();
    }

    @Override
    public List<String> listNativeTags(Biome state) {
        return this.listTags(this.unwrap(state));
    }

    @Override
    public boolean isInNativeTag(String tag, Biome state) {
        return this.isInTag(tag, this.unwrap(state));
    }

    public abstract boolean isInTag(String var1, B var2);

    public abstract List<String> listTags(B var1);

    public abstract boolean equals(B var1, B var2);

    public abstract String getBiomeId(B var1);

    public abstract float getTemperature(B var1);

    public abstract float getHumidity(B var1);

    public abstract RainType getRainType(B var1);

    public abstract boolean isAvailable();

    @Override
    public String getId(Biome type) {
        return type.getBiomeId();
    }

    public static enum RainType {
        NONE,
        RAIN,
        SNOW;

        public static final RainType[] VALUES;

        public static RainType get(String name) {
            if (name == null) {
                return NONE;
            }
            for (RainType pl : VALUES) {
                if (!name.equalsIgnoreCase(pl.name())) continue;
                return pl;
            }
            return NONE;
        }

        static {
            VALUES = RainType.values();
        }
    }
}

